<?php 

/* You have to add users that may use the lifeblog-feature on your
 * blog. Because wordpress does not save the password in its database
 * we can not authenticate against that and have to use our own
 * passwordlist. However, the usernames are matched against the ones in
 * the database and the note/picture/sms/mms is posted as that user.
 *
 * P.S.: empty passwords wont work (disables the account)!
 */
$passwordlist['admin'] = '';
$passwordlist['user1'] = '';
$passwordlist['user2'] = '';
$passwordlist['user3'] = '';

$lifeblog_category = "Lifeblog";
$lifeblog_imagewidth = 220;


/* ======================================== */
/* END OF CONFIGURATION! DO NOT EDIT BELOW! */
/* ======================================== */
require('wp-blog-header.php');
require('wp-admin/admin-functions.php');

function wsse_authenticate($xwsse) {
    global $passwordlist, $wpdb;

    /* parse authheader, backslashes neccessary for lifeblog */
    preg_match('/username=[\\\\"|"]*(?P<username>.*?)[\\\\"|"]*,\s*PasswordDigest=[\\\\"|"]*(?P<digest>.*?)[\\\\"|"]*,\s*Nonce=[\\\\"|"]*(?P<nonce>.*?)[\\\\"|"]*,\s*Created=[\\\\"|"]*(?P<created>.*?)[\\\\"|"]/i', $xwsse, $digest);

    /* TODO: check for old dates (fixes problem with replay attacks)
       even better: check if the nonce has been uses before */

    /* do we know the user? */
    if(!array_key_exists($digest[username], $passwordlist)) return 0;
    
    /* does the user exist in wordpress and has a level > 0? */
    $user_id = $wpdb->get_var("SELECT ID FROM $wpdb->users WHERE user_login =  '".$wpdb->escape($digest[username]) ."'");
    if(!$user_id) $user_id = 0;
    if(!user_can_create_post($user_id, 1)) return 0;

    /* calculate our own digest and compare it */
    $mydigest = base64_encode(pack("H*", sha1($digest[nonce] . $digest[created] . $passwordlist[$digest[username]])));
    if($mydigest != $digest[digest]) return 0;

    /* we seem to have a valid user */
    return $user_id;
}

function logme($message) {
    $handle = fopen("atomdata.txt", "a");
    $date = date('Y-m-d\Th:i:s\Z');
    fwrite($handle, $date . ": " . $message . "\n");
    fclose($handle);
}

function error($message) {
    header('Status: 400 Posterror');
    echo "$message\n";
    logme("error: $message");
    exit;
}

/* default action */
$action = 'list';
if($_SERVER["REQUEST_METHOD"] == "POST") {
    $action = 'post';    
}

//$fh = fopen("atomtest.txt", "r");
//$HTTP_RAW_POST_DATA = fread($fh, filesize("atomtest.txt"));
//fclose($fh);
//$action = 'post';

$myheader = "UsernameToken Username=\\\"admin\\\", PasswordDigest=\\\"doxqqkGyBdMB5K2kospnQZmkXSI=\\\", Nonce=\\\"vks5AODOrBoPjo0DL9lCOQ==\\\", Created=\\\"2005-8-12T13:18:22Z\\\"";
if($_SERVER[HTTP_X_WSSE]) $myheader = $_SERVER[HTTP_X_WSSE];


// LOG HIT

logme("method: ".$_SERVER['REQUEST_METHOD']);
logme("rawpostdata: " . $HTTP_RAW_POST_DATA);
foreach ($_POST as $key=>$value) {  /*logme("$key: $value");*/ }

/* check the passworddigest */
if(!($user_id = wsse_authenticate($myheader))) {
    header('Status: 401 Unauthorized');
    header('WWW-Authenticate: WSSE realm="'.bloginfo('name').'", profile="UsernameToken"');
    header('Content-type: text/plain; charset=' . get_settings('blog_charset'), true);
    echo "Unauthorised!\n";
    logme("login error: user unauthorised");
    exit;
}


/* send our beloved atom/xml-header */
header('Content-type: application/atom+xml; charset=' . get_settings('blog_charset'), true);

if($action == 'list') {


echo '<?xml version="1.0" encoding="'.get_settings('blog_charset').'"?'.'>';?>
<feed version="0.3"
 xmlns="http://purl.org/atom/ns#"
 xmlns:dc="http://purl.org/dc/elements/1.1/"
 xml:lang="<?php echo get_option('rss_language'); ?>">
    <link rel="service.post" href="<?php bloginfo('url'); ?>/lifeblog.php" type="application/atom+xml" title="<?php bloginfo('name'); ?>" />
    <link rel="service.feed" href="<?php bloginfo('atom_url'); ?>" type="application/atom+xml" title="<?php bloginfo('name'); ?>" />
    <link rel="alternate" href="<?php bloginfo('url'); ?>" type="text/html" title="<?php bloginfo('name'); ?>" />
</feed>

<?php } elseif($action == 'post') {

logme("postaction");
/* standalone object */
if(preg_match('/<typepad:standalone>/i', $HTTP_RAW_POST_DATA) && 
    preg_match('/<summary>/i', $HTTP_RAW_POST_DATA)) {
    
    /* sms/note/mms */
    if(preg_match('/<title>(?P<title>.*?)<\/title>.*?<dc:type>(?P<dctype>.*?)<\/dc:type>.*?<dc:format>(?P<dcformat>.*?)<\/dc:format>.*?<content\s*type="(?P<contenttype>.*?)"\s*mode="(?P<contentmode>.*?)">(?P<content>.*?)<\/content>.*?<summary>(?P<summary>.*?)<\/summary>/si', $HTTP_RAW_POST_DATA, $data)) {
	$filename_ending = ".txt";
    /* image */
    } elseif(preg_match('/<title>(?P<title>.*?)<\/title>.*?<content\s*type="(?P<contenttype>.*?)"\s*mode="(?P<contentmode>.*?)">(?P<content>.*?)<\/content>.*?<summary>(?P<summary>.*?)<\/summary>/si', $HTTP_RAW_POST_DATA, $data)) {
	$filename_ending = ".jpg";
	$data[dctype]="Image";
	$data[dcformat]="Image";
    } else {
	// BAIL OUT!!!
	error("I do not recognize the xml of the standalone-object");
    }
    logme("filetype: $filename_ending");
    
    /* can we write to the upload directory? */
    if (!is_writable(get_settings('fileupload_realpath')))
	error("Wordpress upload directory is not writable");
    
    /* find a unique filename */
    $filename_counter = 2;
    $filename = "/lifeblog-". $data[title];
    $pathtofile = $filename . $filename_ending;
    while( file_exists(get_settings('fileupload_realpath') . $pathtofile) ) {
	$pathtofile = $filename . "_" . $filename_counter++ . $filename_ending;
	if($filename_counter > 100) error("could not save uploaded file");
    }

    logme("filename: $pathtofile");

    /* save the file */
    $temp = fopen(get_settings('fileupload_realpath').$pathtofile, "w");
    if($data[contentmode] == "base64") $data[content] = base64_decode($data[content]);
    fwrite($temp, $data[content]);
    fclose($temp);
    
    /* we need to recognize related content later */
    $newid = "url:$pathtofile,type:$data[dctype],format:$data[dcformat],summary:".$wpdb->escape($data[summary]);
    logme("id: $newid");
    
    /* answer */
    header('Status: 201 Created');
    echo '<?xml version="1.0" encoding="'.get_settings('blog_charset').'"?'.'>';?>
    <entry xmlns="http://purl.org/atom/ns#">
    <title>blog entry</title>
    <summary>blog summary</summary>
    <issued><?php echo date('Y-m-d\Th:i:s\Z'); ?></issued>
    <link type="text/html" rel="alternative" href="<?php echo get_settings('fileupload_url').$pathtofile; ?> title="HTML" />
    <id><?php echo $newid; ?></id>
    </entry>
    <?php
    

/* the blog posting */
} else {

    if(preg_match('/<title>(?P<title>.*?)<\/title>.*?<created>(?P<created>.*?)<\/created>.*?<content\s*type="(?P<contenttype>.*?)"\s*mode="(?P<contentmode>.*?)">(?P<content>.*?)<\/content>(?P<links>.*?)<\/entry>/si', $HTTP_RAW_POST_DATA, $data) &&
	preg_match_all('/<link.*?type="(?P<linktype>.*?)"\s*href="url:(?P<linkurl>.*?),type:(?P<linktype2>.*?),format:(?P<linkformat>.*?),summary:(?P<linksummary>.*?)"\/>/si', $data[links], $related)) {
	
	/* construct the new post */
	$post_date = current_time('mysql');
	$post_date_gmt = current_time('mysql', 1);
	//$post_status = 'draft';
	$post_status = 'publish';
	$post_title = $data[title];
	if($lifeblog_category) {
	    logme("custom category");
	    if(!($cat_ID = $wpdb->get_var("SELECT cat_ID FROM $wpdb->categories WHERE cat_name ='".$wpdb->escape($lifeblog_category)."'"))) {
		$lifeblog_category = $wpdb->escape(wp_specialchars($lifeblog_category));
		$id_result = $wpdb->get_row("SHOW TABLE STATUS LIKE '$wpdb->categories'");
		$cat_ID = $id_result->Auto_increment;
		$category_nicename = sanitize_title($lifeblog_category, $cat_ID);
		logme("nicename is: $category_nicename");
		$wpdb->query("INSERT INTO $wpdb->categories (cat_name, category_nicename, category_description)
				    VALUES
				('$lifeblog_category', '$category_nicename', 'Lifeblog category')");
		logme("category added");
	    }
	    $post_category = array($cat_ID);

	} else {
	    $post_category = $post_default_category;
	    logme("using default category");
	}
        logme("category: $post_category");
	$post_author = $user_id;
	
	
	/* the content ... */
	$content = "<div class=\"Lifeblog_Posting\">\n";
	for($i=0;$i<count($related[linktype]);$i++) {
    	    //logme("nr ". ($i+1).".: ".$related[linktype][$i].", ".$related[linkurl][$i].", ".$related[linktype2][$i].", ".$related[linkformat][$i].", ".$related[linksummary][$i]);
	    if(file_exists(get_settings('fileupload_realpath') . $related[linkurl][$i])) {
		$content .= "<div class=\"Lifeblog_Resource\">\n";	    
		if($related[linktype2][$i] == "Image" && $related[linkformat][$i] == "Image") {
		    if(!$lifeblog_imagewidth || !is_numeric($lifeblog_imagewidth)) $lifeblog_imagewidth = 450;
		    $returnvalue = wp_create_thumbnail(get_settings('fileupload_realpath') . $related[linkurl][$i], $lifeblog_imagewidth);
		    if($returnvalue == 1) { 
			logme($returnvalue);
			$path = explode('/', $related[linkurl][$i]);
			$thumbpath = '/thumb-' . $path[count($path)-1];
			$content .= "<a href=\"".get_settings('fileupload_url') . $related[linkurl][$i] . "\"><img src=\"".get_settings('fileupload_url') . $thumbpath . "\" alt=\"".htmlentities2(stripslashes($related[linksummary][$i]))."\" /></a>";
		    } else {
			$content .= "<img src=\"".get_settings('fileupload_url') . $related[linkurl][$i] . "\" alt=\"".htmlentities2(stripslashes($related[linksummary][$i]))."\" />";
		    }
		    			
		} else {
		    $filename = get_settings('fileupload_realpath') . $related[linkurl][$i];
		    $fh = fopen($filename, "r");
		    $filecontent = fread($fh, filesize($filename));
		    fclose($fh);
		    $content .= "<div class=\"Lifeblog_". $related[linkformat][$i] ."\">\n";
		    if($related[linksummary][$i] != '')
			$content .= stripslashes($related[linksummary][$i])." (".$related[linkformat][$i]."):\n";
		    $content .= "<blockquote>$filecontent</blockquote>\n";
		    $content .= "</div>\n";
		}
		$content .= "</div>\n";
	    } else {
		logme("A related resource could not be found");
	    }
	}
	$content .= "$data[content]\n";
	$content .= "</div>";
	$post_content = apply_filters( 'content_save_pre', $content);


	/* publish post */
	$post_data = compact('1', 'post_author', 'post_date', 'post_date_gmt', 'post_content', 'post_title', 'post_category', 'post_status');
	$post_ID = wp_insert_post($post_data);

	if(!$post_ID) {
	    error("Something went wrong while posting!");
	}														 


    } else {
	// BAIL OUT!
	error("I do not recognize the xml");
    }

    
    header('Status: 201 Created');
    echo '<?xml version="1.0" encoding="'.get_settings('blog_charset').'"?'.'>';?>
    <entry xmlns="http://purl.org/atom/ns#">
    <title>blog entry</title>
    <summary>blog summary</summary>
    <issued><?php echo date('Y-m-d\Th:i:s\Z'); ?></issued>
    <link type="text/html" rel="alternative" href="<?php bloginfo('url'); ?>" title="HTML" />
    <id><?php bloginfo('url'); ?></id>
    </entry>
    <?php

} 

} else error("Unrecognized request");

logme("=========================");

?>