<?php
/*
Plugin Name: Performance Logger
Version: 0.1
Description: Displays performance information in a html comment on the bottom of every page - <em>Please make sure you add <strong>define('SAVEQUERIES', true);</strong> to your defines in wp-config.php</em>
Plugin URI: http://www.sebbi.de
Plugin Author: Sebastian Herp
Author URI: http://www.sebbi.de
*/


class Perflogger {
	var $perflog_log = '';
	var $hookms = 0;
	
	var $mslimit = 1; //change this to 0 if you want to see all queries

	function Perflogger() {
		add_action('init', array(&$this,'perflog_hook_init'));
		add_action('template_redirect', array(&$this,'perflog_hook_template_redirect'));
		add_action('plugins_loaded', array(&$this,'perflog_hook_plugins_loaded'));
		add_filter('wp_footer', array(&$this,'perflog_hook_wp_footer'));
		add_filter('wp_head', array(&$this,'perflog_hook_wp_head'));
		add_filter('the_content', array(&$this,'perflog_hook_the_content'));
		add_filter('comments_template', array(&$this,'perflog_hook_comments_template'));

		add_filter('wp_footer', array(&$this,'perflog_display'));
		$this->perflog_logger('plugin_init');
	}
	
	function perflog_hook_init() { $this->perflog_logger('init'); }
	function perflog_hook_template_redirect() { $this->perflog_logger('template_redirect'); }
	function perflog_hook_wp_footer() { $this->perflog_logger('wp_footer'); }
	function perflog_hook_wp_head() { $this->perflog_logger('wp_head'); }
	function perflog_hook_plugins_loaded($arg) { $this->perflog_logger('plugins_loaded'); return $arg;}
	function perflog_hook_the_content($arg) { $this->perflog_logger('the_content'); return $arg;}
	function perflog_hook_comments_template($arg) { $this->perflog_logger('comments_template'); return $arg;}
		



	function perflog_logger($hook = '') {
		$ms = timer_stop(0) * 1000;
		$delta = $ms - $this->hookms;
		$this->hookms = $ms;
		$this->perflog_log .= "hook: $hook, from start:".round($ms,2)." ms, delta:".round($delta,2)." ms\n";
	}


	function perflog_display() {
		global $wpdb, $perflog_log;
		
		$querytimebig = 0; 
		$querytimesmall = 0;
		$querycountbig = 0;
		$querycountsmall = 0;
		
		echo "\n<!--\n";
		echo "Displaying queries which took over $this->mslimit ms to execute:\n";
		if($wpdb->queries) foreach ($wpdb->queries as $q) {
			$querytime += $q[1];
			if($q[1]*1000 > $this->mslimit) {
				echo ($q[1]*1000)." ms: for\"$q[0]\"\n";
				$querycountbig++;
				$querytimebig += $q[1]*1000;
			} else {
				$querycountsmall++;
				$querytimesmall += $q[1]*1000;
			}
		}
		echo "\n\n";
		echo "Stats:\n";
		echo "$querycountbig big queries (over $this->mslimit ms) taking $querytimebig ms to execute\n";
		echo "and $querycountsmall small queries eating $querytimesmall ms of your time.\n";
		echo "That sums up to " . ($querycountbig + $querycountsmall) . " queries in " . ($querytimebig + $querytimesmall) . " ms\n";

		echo "\n";
		echo "Hooks:\n";
		echo $this->perflog_log;
		
		echo "\n-->\n";
	}


}

$perflogger = new Perflogger();



?>