<?php
/*

	Akismet Check for Spam Karma 2
	Checks comment against Akismet (www.akismet.com) webservice
	(c) 2006 Sebastian Herp and HEAVILY based on the original akismet plugin (Matt Mullenweg)

*/

/* README
 * You can modify the skip_under and skip_above values of the class if you
 * want to. The default is -100 and 100. With these values Akismet.com is
 * contacted on nearly every comment except those really bad ones we
 * definetly need no confirmation for. This might be ok for smaller blogs,
 * but could result in performance problems on bigger blogs. If you feel
 * commenting on your blog takes to much time and you do only want to check
 * comments against Akismet where Spam Karma 2 isn't really sure,
 * set the values to something like -10 and 10. This way this plugin only
 * does its magic on very few comments.
*/

// raise/hit comment with how many karma points?
// 7 was a good value in my longtime experiments :-)
define(KARMAPOINTS, 7);

// if Akismet was wrong, what level should the logmessages have?
// 8 is a high value, but it happens seldom enough and it does not get
// deleted by the default log purge :-)
define(LOGLEVELAKISMETWRONG, 8);

class sk2_akismet_plugin extends sk2_plugin
{
	var $name = "Akismet Check";
	var $author = "<small>Sebastian Herp</small>";
	var $author_email = "mail@sebbi.de?subject=Spamkarma2 Akismet Plugin";
	var $description = "Checks comment against Akismet web service";
	var $plugin_help_url = "http://www.sebbi.de/archives/2006/01/31/spam-karma-2-akismet-plugin/";
	var $author_url = "http://www.sebbi.de";
	var $plugin_version = 2.1;
	var $show_version = true;
  var $skip_under = -100;
	var $skip_above = 100;
			
	var $settings_format = array
	(
	    "do_submit" => array
	    (
		"type" => "check",
		"value" => true,
		"caption" => "Submit comments to Akismet.com if they were classified wrong (more in the advanced options)"
	    ),
	    "submit_under" => array
	    (
		"type" => "text",
		"value" => "-5",
		"caption" => "Correct Akismet.com (submit comment as spam) if karma is below",
		"after" => "and Akismet said it's ham",
		"size" => 4,
		"advanced" => true
	    ),
	    "submit_above" => array
	    (
		"type" => "text",
		"value" => "5",
		"caption" => "Correct Akismet.com (submit comment as ham) if karma is above",
		"after" => "and Akismet said it's spam",
		"size" => 4,
		"advanced" => true
	    ),
	    "wordpresscom_apikey" => array
	    (
		"type" => "text",
		"value" => "",
		"caption" => "WordPress.com API Key:",
		"after" => "(<a href=\"http://faq.wordpress.com/2005/10/19/api-key/\">What is this?</a>)",
		"size" => 15
	    )	    
	);
	
	var $filter = true; // note: you can define a plugin with both a filter and a treatment functions
	var $treatment = true;
	
	var $akismet_true = "Akismet says it's spam";
	var $akismet_false = "Akismet says it's ok";
	
	function filter_this(&$cmt_object)
	{
		global $wpdb;

		$apikey = $this->get_option_value('wordpresscom_apikey');
		
		if( '' == $apikey ) // no valid api key entered
		{
		    $this->log_msg("WordPress.com API key is not valid. Can't check comment against Akismet.com", 4);
		    return;
		}

		$comment_array['comment_post_ID'] = $cmt_object->ID;
		$comment_array['comment_author'] = $cmt_object->author;
		$comment_array['comment_author_email'] = $cmt_object->author_email;
		$comment_array['comment_author_url'] = $cmt_object->author_url['href'];
		$comment_array['comment_content'] = $cmt_object->content;
		if($cmt_object->is_comment()) $comment_array['comment_type'] = '';
		if($cmt_object->is_pingback()) $comment_array['comment_type'] = 'pingback';
		if($cmt_object->is_trackback()) $comment_array['comment_type'] = 'trackback';
		$comment_array['user_ID'] = $cmt_object->user_id;
		$comment_array['user_ip'] = $cmt_object->author_ip;
		$comment_array['user_agent'] = $wpdb->get_var("SELECT comment_agent FROM $wpdb->comments WHERE comment_ID = '{$cmt_object->ID}'");
		$comment_array['referrer'] = '';
		if(!$cmt_object->is_post_proc()) $comment_array['referrer'] = $_SERVER['HTTP_REFERER'];
		$comment_array['blog'] = get_option('home');

	        $query_string = '';
	        foreach ( $comment_array as $key => $data )
                    $query_string .= $key . '=' . urlencode( stripslashes($data) ) . '&';

		
		$response = $this->http_post($query_string, $apikey . '.rest.akismet.com', '/1.1/comment-check', 80);
		if ( 'true' == $response[1] )
		{
		    $this->hit_karma($cmt_object, KARMAPOINTS, $this->akismet_true);
		}
		else if( 'invalid' == $response[1] )
		{
		    $this->set_option_value('wordpresscom_apikey', '');
		    $this->log_msg("WordPress.com API key is not valid. Please enter a valid one in the configuration", 5);
		}
		else
		{
		    $this->raise_karma($cmt_object, KARMAPOINTS, $this->akismet_false);
		}
		
	}
	
	function treat_this(&$cmt_object)
	{
		
	    $apikey = $this->get_option_value('wordpresscom_apikey');
	    if( '' == $apikey ) // no valid api key entered
	    {
	        $this->log_msg("WordPress.com API key is not valid. Can't check comment against Akismet.com", 4);
	        return;
	    }

	    $reason = '';
	    foreach ( $cmt_object->karma_cmts as $key => $kcmtarray )
	    {
			if( $reason == '' )
		    if($kcmtarray['plugin'] == $this->name)
				$reason = $kcmtarray['reason'];
	    }
	    
	    if( $reason == '' )
		return;
	    
	    if( "on" != $this->get_option_value('do_submit') )
		return;
	    
	    // we are sure it's ham, but akismet was not
	    if($cmt_object->karma > $this->get_option_value('submit_above') && $reason == $this->akismet_true) 
	    {
		$this->submit_comment($cmt_object->ID, 'ham');
		$this->log_msg("Submitted comment " . $cmt_object->ID . " to Akismet.com as ham (Akismet said it's spam)", LOGLEVELAKISMETWRONG);
		return;
	    }
	    // we are pretty sure it's spam, but akismet was not
	    else if( $cmt_object->karma < $this->get_option_value('submit_under') && $reason == $this->akismet_false) 
	    {
		$this->submit_comment($cmt_object->ID, 'spam');
		$this->log_msg("Submitted comment " . $cmt_object->ID . " to Akismet.com as spam (Akismet said it's ham)", LOGLEVELAKISMETWRONG);
		return;
	    }


	}
	
	function output_plugin_UI ($output_dls = true)
	{

	    $invalid_key = '';
	    if( '' != $this->get_option_value('wordpresscom_apikey') && !$this->akismet_verify_key($this->get_option_value('wordpresscom_apikey')) )
	    {
	        $invalid_key = $this->get_option_value('wordpresscom_apikey');
		$this->set_option_value('wordpresscom_apikey','');
		
	    }

	    parent::output_plugin_UI($output_dls);
	    
	    if( '' != $invalid_key )
	    {
		if($output_dls)
		    echo "<dl>";
		echo "<span style=\"color: red\">The entered WordPress.com API Key ($invalid_key) appears to be not valid.</span>";
		if ($output_dls)
		    echo "</dl>";
	    }
	}

	function akismet_verify_key( $key )
	{
	    $blog = urlencode( get_option('home') );
	    $response = $this->http_post("key=$key&blog=$blog", 'rest.akismet.com', '/1.1/verify-key', 80);
	    if ( 'valid' == $response[1] )
	            return true;
	    else
	            return false;
	}
										
	function http_post($request, $host, $path, $port = 80)
	{
	    global $wp_version;
	    
	    $http_request  = "POST $path HTTP/1.0\r\n";
	    $http_request .= "Host: $host\r\n";
	    $http_request .= "Content-Type: application/x-www-form-urlencoded; charset=" . get_settings('blog_charset') . "\r\n";
	    $http_request .= "Content-Length: " . strlen($request) . "\r\n";
	    $http_request .= "User-Agent: WordPress/$wp_version | Spamkarma2 (Akismet Plugin/{$this->version}.00)\r\n";
	    $http_request .= "\r\n";
	    $http_request .= $request;
	    
	    //$this->log_msg("http_request: $http_request",4);
	    
	    $response = '';
	    if( false !== ( $fs = @fsockopen($host, $port, $errno, $errstr, 3) ) ) {
	        fwrite($fs, $http_request);
	        while ( !feof($fs) )
	            $response .= fgets($fs, 1160); // One TCP-IP packet
	        fclose($fs);
	        $response = explode("\r\n\r\n", $response, 2);
	    }
	    
	    //$this->log_msg("response: $response[1]",4);
	    
	    return $response;
	}

	function submit_comment ( $comment_id, $comment_type = 'spam' )
	{
    	    global $wpdb, $ksd_api_host, $ksd_api_port;
	
	    if( 'spam' != $comment_type )
		$comment_type = "ham";
	    $apikey = $this->get_option_value('wordpresscom_apikey');
	    if( '' == $apikey )
	        return;
	    $comment = $wpdb->get_row("SELECT * FROM $wpdb->comments WHERE comment_ID = '$comment_id'");
	    if ( !$comment ) // it was deleted
	        return;
	    $comment->blog = get_option('home');
	    $query_string = '';
	    foreach ( $comment as $key => $data )
	        $query_string .= $key . '=' . urlencode( stripslashes($data) ) . '&';
	    
	    $response = $this->http_post($query_string, $apikey . '.rest.akismet.com', "/1.1/submit-$comment_type", 80);
	}
																
}

$this->register_plugin("sk2_akismet_plugin", 9);

?>